      SUBROUTINE makebcf(u,v,nx,ny)
c
c   Full conditions for velocity field

      include 'undefined.h'
      INTEGER nx,ny
      DOUBLE PRECISION u(nx,ny), v(nx,ny)
      INTEGER i,j

      do i=1,nx
         u(i,1)=u(i,2)
         v(i,1)=0.d0
         v(i,2)=0.d0
         u(i,ny) = u(i,ny-1)
         v(i,ny) = 0.
      enddo
      do i=1,ny
         u(1,i) = u(nx-1,i)
         v(1,i) = v(nx-1,i)
         u(nx,i) = u(2,i)
         v(nx,i) = v(2,i)
      enddo
      return
      end

      SUBROUTINE bcvechom(u,v,nx,ny)
c
c     Homogenous conditions corresponding to velocity field. 
c
      include 'undefined.h'
      INTEGER nx,ny
      DOUBLE PRECISION u(nx,ny), v(nx,ny)
      INTEGER i,j

c     Since velocity field conditions are already homogneous, just copy them.      
      call makebcf(u,v,nx,ny) 

      return
      end

      SUBROUTINE makebcsf(S11,S22,S12,nx,ny)
      include 'undefined.h'
      integer nx,ny
      DOUBLE PRECISION s11(nx,ny),s22(nx,ny),s12(nx,ny)
      INTEGER i,j

      do i=1,nx
         S12(i,2) = 0.d0
         S12(i,ny) = 0.d0
      enddo
      do j=1,ny
         S11(1,j) = S11(nx-1,j)
         S22(1,j) = S22(nx-1,j)
         S12(1,j) = S12(nx-1,j)
         S11(nx,j) = S11(2,j)
         S22(nx,j) = S22(2,j)
         S12(nx,j) = S12(2,j)
      enddo


      return
      end

      SUBROUTINE makebccf(cc,nx,ny)
      include 'undefined.h'
      INTEGER nx,ny
      DOUBLE PRECISION cc(nx,ny)
      INTEGER i,j
c
      do i=1,nx
         cc(i,1) = cc(i,2)
         cc(i,ny) = cc(i,ny-1)
      enddo
      do i=1,ny
         cc(1,i) = cc(nx-1,i)
         cc(nx,i) = cc(2,i)
      enddo

      return
      end
      SUBROUTINE makebcpf(cc,nx,ny)
      include 'undefined.h'
      INTEGER nx,ny
      DOUBLE PRECISION cc(nx,ny)
      INTEGER i,j
c
      do i=1,nx
         cc(i,1) = cc(i,2)
         cc(i,ny) = cc(i,ny-1)
      enddo
      do i=1,ny
         cc(1,i) = cc(nx-1,i)
         cc(nx,i) = cc(2,i)
      enddo

      return
      end

      SUBROUTINE makebcresf(res,nx,ny)
      include 'undefined.h'
      INTEGER nx,ny
      DOUBLE PRECISION res(nx,ny)
      INTEGER i,j

      do i=1,nx
         res(i,1) = 0.d0
         res(i,ny) = 0.d0
      enddo
      do i=1,ny
         res(1,i) = res(nx-1,i)
         res(nx,i) = res(2,i)
      enddo
 
      return
      END

      SUBROUTINE makebcxvof(vof1,vof3,nx,ny)
      include 'undefined.h'
      INTEGER i,nx,ny
      DOUBLE PRECISION vof1(nx,ny),vof3(nx,ny)

      do i=2,ny-1
         vof3(1,i)=vof3(nx-1,i)
         vof1(nx,i)=vof1(2,i)
      enddo

      return
      END

      SUBROUTINE makebczvof(vof1,vof3,nx,ny)
      include 'undefined.h'
      INTEGER i,nx,ny
      DOUBLE PRECISION vof1(nx,ny),vof3(nx,ny)
 
      do i=2,nx-1
         vof3(i,1)=0.0d0
         vof1(i,ny)=0.0d0
      enddo
 
      return
      END

c***********************************************************************
      SUBROUTINE makebcflux(flxm,flxp,flzm,flzp,nx,nz)
c***
      INCLUDE 'undefined.h'
      INTEGER i,k,nx,nz
      DOUBLE PRECISION flxm(nx,nz),flxp(nx,nz),flzm(nx,nz),flzp(nx,nz)
c***
      do k=2,nz-1
         flxp(1,k) = flxp(nx-1,k)
         flxm(nx,k) = flxm(2,k)
      enddo 
      do i=2,nx-1
         flzp(i,1) = 0.d0
         flzm(i,nz) = 0.d0
      enddo 
c***
      return
      end


      SUBROUTINE corner(u,v,cc,nx,ny)
      integer nx,ny
      double precision u(nx,ny), v(nx,ny), cc(nx,ny)
      integer i, j 

      u(1,1) =0.d0
      v(1,1) = 0.d0
      u(1,ny) =0.d0
      v(1,ny) =0.d0
      u(nx,1) = 0.d0
      v(nx,1) = 0.d0
      u(nx,ny) = 0.d0
      v(nx,ny) = 0.d0
      cc(1,1) = cc(2,2)
      cc(1,ny) = cc(2,ny-1)
      cc(nx,1) = cc(nx-1,2)
      cc(nx,ny) = cc(nx-1,ny-1)
      return
      end

      SUBROUTINE ccorner(cc,nx,ny)
      integer nx,ny
      double precision cc(nx,ny)
      integer i, j 

      cc(1,1) = cc(2,2)
      cc(1,ny) = cc(2,ny-1)
      cc(nx,1) = cc(nx-1,2)
      cc(nx,ny) = cc(nx-1,ny-1)
      return
      end
