      SUBROUTINE timestep(t,tprint)
      include 'undefined.h'
      INTEGER tprint,tvelo,t,cinalg,idrop, istspur
      INTEGER printdiv,i,j,nfilter, tspurious, capalg
      DOUBLE PRECISION  velmax, sumfield,h,tau1
      DOUBLE PRECISION  velspur, cagas, caliq, radius
      INTEGER ibubble, iparticle, iforce
      INTEGER nz

      double precision findninf,findmax,findmin, maxkappa, minkappa
      character*80 c
      INCLUDE 'size.h'
      INCLUDE 'global.f'
      INCLUDE 'pointers.f'
      INCLUDE 'zop.f'
c
      nz=1
      tstep = t
      idrop=0
      i=ifetch("drop",idrop)
      ibubble=0
      i=ifetch("bubble",ibubble)
      if(ibubble+idrop.eq.2)  stop "can t have both drop and bubble"

      iparticle=0
      if(ibubble+idrop.eq.1) iparticle=1

      istspur=0
      istspur=ifetch("tspurious",tspurious)
      if(tspurious.le.0) then
         istspur=0
      endif
c     
c     If a drop calculation the lengthscale is radius*lengthscale
c     lengthscale is external, through global.f
c
      radius=0
      i=dfetch("radius",radius)
      if(iparticle.eq.1.and.i.eq.0) stop "missing radius"
      
      printdiv=1
      i=ifetch("printdiv",printdiv)
c
c  Send important output to a file (unit 66)
c  that will always be opened and closed, so that it can be read while
c  the program runs. 
c
c  First delete the file at t=0

      if(t.eq.0) then 
         open(unit=66,file='msg',status="unknown")
         close(unit=66,status="delete")
         if(iparticle.eq.1) open(unit=67,file='spur',status="unknown")
         open(unit=68,file="zop.out",status='unknown')
         zop=0
         allzops=0.d0
      endif

c Read to the end of the file

100   format(a80)
      open(unit=66,file='msg',status="unknown")
 7771 read(66,100,end=7772,err=7773) c
      go to 7771
 7773 write(6,*) "error reading file msg"
      stop
 7772 continue

      if(t.eq.0)  write(6,*) "printdiv=",printdiv
c
c Control CFL condition
c
      velmax = findninf(u,v,nx,ny)
      if( velmax.gt. MAXCFL) then
         write(6,*) "surfer:warning> t velmax",t, velmax
         call datbfile(u,v,z(icc(ng)),z(iu(ng)),nx,ny,nz,t
     *        ,sigma,tau)
         stop 'CFL number too large. Try smaller tau'
      endif
c
c Some output
c
      if(mod(t,tprint).eq.0) then
         write(6,*) ":surfer,CFL> ",t,velmax
         write(66,*)  ":surfer,CFL> ",t,velmax
         write(6,*) "mass=",sumfield(z(icc(ng)),nx,ny)
         write(6,*) "max C", findmax(z(icc(ng)),nx,ny,i,j), 
     $              "min C", findmin(z(icc(ng)),nx,ny,i,j)
         call flush(6)
      endif
c
c Output some fields
c
c Writes a datb file format 
c (http://www.lmm.jussieu.fr/MEMBRES/POPINET/popiplot/index.html)
c
      i=ifetch("tvelo",tvelo)
      if(mod(t,tvelo).eq.0) then
        call datbfile(u,v,z(icc(ng)),z(iu(ng)),nx,ny,nz,t
     *        ,sigma,tau)
      endif

c
      tzop=1000
      i=ifetch("tzop",tzop)
      if(mod(t,tzop).eq.0) then
         allzops = allzops + 1.d0*zop      !! /(1.d0*tmax)
         write(68,*) t, zop, allzops
         zop=0
      endif

c
c  Define the space step value, deduced from nx as everywhere else
c
      h=1.d0/(nx-2)
c
      if(istspur.ne.0) then
         if(mod(t,tspurious).eq.0) then
c
c   Here is a good example of the difficulty with dimensionless 
c   variables in the code. 
c 
c   core dimensionless units (units "2") : u2 = u1 tau / h
c   basic dimensionless units (units "1"): u1 = u timescaleSI / lengthscale
c   where u, lengthscale are dimensional  (units "D") 
c      (in cgs or SI or whatever) 
c
c then
c
c   caliq =  velspur (1) *muliq (1) /sigma (1) =  u (D) *muliq (D) /sigma (D) 
c
c   velmax is U_max (2) 
c   velspur is U_max (1) and muliq, sigma are in units (1) 

           velspur = velmax*h/tau
           caliq = velspur*muliq/sigma
           cagas = velspur*mugas/sigma
           write(67,*) t,caliq,cagas
        endif
      endif
c
c  Calls CIAM
c     
      if(mod(t,2).eq.0) then
         call x_swp(u,z(icc(ng)),z(iei(ng)),
     $        z(ires(ng)),z(irhs(ng)),nx,ny)
         call z_swp(v,z(icc(ng)),z(iei(ng)),
     $        z(ires(ng)),z(irhs(ng)),nx,ny)
      else
         call z_swp(v,z(icc(ng)),z(iei(ng)),
     $        z(ires(ng)),z(irhs(ng)),nx,ny)
         call x_swp(u,z(icc(ng)),z(iei(ng)),
     $        z(ires(ng)),z(irhs(ng)),nx,ny)
      end if
c        CIAM_Raus deprecated

c         call ciam_raus(u,v,z(icc(ng)),z(iei(ng)),
c     $        z(ires(ng)),z(irhs(ng)),z(ia(ng)),z(ic(ng)),S11,nx,ny)

      if(sigma.eq.0.d0) then
         call fill0(S11,nx,ny)
         call fill0(S22,nx,ny)
         call fill0(S12,nx,ny)
      else
c     
c     gets a parameter to determine whether we filter C before 
c     computing surface tension. Then compute surface tension
c     in two steps. 
c
c     1) The filtered C goes into z(irhs(ng))which  will now be a pointer
c        to the filtered volume fraction field
c     
         nfilter=0
         i=ifetch("nfilter",nfilter) 
         call corner(z(ires(ng)),z(irhs(ng)),z(icc(ng)),nx,ny)
         if(nfilter.eq.0) then 
            call copy(z(irhs(ng)),z(icc(ng)),nx,ny)
            call makebccf(z(irhs(ng)),nx,ny)
         else
            call filter(z(icc(ng)),z(irhs(ng)),nx,ny)
            call makebccf(z(irhs(ng)),nx,ny)
            do i=1,nfilter-1
               call copy(z(iei(ng)),z(irhs(ng)),nx,ny)
               call filter(z(iei(ng)),z(irhs(ng)),nx,ny)
               call makebccf(z(irhs(ng)),nx,ny)
            enddo
         endif

c       2) Now for the actual computation of spurious currents. First 
c          select the algorithm
c
         capalg=1
         i=ifetch("capalg",capalg)
         if(capalg.eq.1) then
            call stresses(S11,S22,S12,z(irhs(ng)),z(iei(ng)),
     $           z(ires(ng)),sigma,tau,nx,ny)    
         else if (capalg.eq.2) then
            call capcsf(S11,S22,z(ires(ng)),z(irhs(ng)),
     $           sigma,tau,nx,ny)    
         else if (capalg.eq.3) then
            call csfbkz(S11,S22,S12,z(ires(ng)),z(irhs(ng)),
     $           sigma,tau,nx,ny)    
         else if (capalg.eq.4) then
            call csfrtz(S11,S22,z(ires(ng)),z(irhs(ng)),z(icc(ng)),
     $           sigma,tau,nx,ny)    
         else
            write(6,*) 'Surfer: time_step: capalg parameter > 4'
            STOP 'capalg'
         endif
      endif
c
      i=ifetch("tvelo",tvelo)
      i=ifetch("forcefile",iforce)
      if(i.eq.0) iforce=0
      if((mod(t,tvelo).eq.0).and.(iforce.eq.1)) then
        call forcefile(z(ires(ng)),z(irhs(ng)),z(icc(ng)),nx,ny,nz,t)
      endif

      call momentum(rhou,rhov,u,v,z(icc(ng)),z(iu(ng)),z(ia(ng)),
c                    rhou,rhov,u,v,  cc,        p,        a,
     *     z(ic(ng)),z(iei(ng)),S11,S22,S12,
c     *                    c,ei,S11,S22,S12,w1,w2,
     *     z(ires(ng)),z(irhs(ng)),tau,mugas,muliq,
     *     rhogas,g,nx,ny,printdiv,t) 
      
      close(unit=66)
      return
      end
