c$$$    SURFER fluid interface simulation program
c$$$    Copyright (C) 2001 Stephane Zaleski and others
c$$$
c$$$    This library is free software; you can redistribute it and/or
c$$$    modify it under the terms of the GNU Lesser General Public
c$$$    License as published by the Free Software Foundation; either
c$$$    version 2.1 of the License, or (at your option) any later version.
c$$$
c$$$    This library is distributed in the hope that it will be useful,
c$$$    but WITHOUT ANY WARRANTY; without even the implied warranty of
c$$$    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
c$$$    Lesser General Public License for more details.
c$$$
c$$$    You should have received a copy of the GNU Lesser General Public
c$$$    License along with this library; if not, write to the Free Software
c$$$    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
c$$$
c$$$    Stephane Zaleski zaleski@lmm.jussieu.fr
ccc
c
c  Research version of CSF method. Three filters: grad, div and cc. 
c
c   On input:
c   
c        cc         true volume fractions
c        ccf      filtered volume fractions
c        w1         arbitrary nx*ny array;
c        w2              "
c        w3
c        sigma     surface tension coefficient.
c        
c   
c   On output
c   
c        w3    first component of force multiplied by tau/h
c        ccf second "   "  "  "  "  "
c
c        in momentum.f  at locations described on figure.
c   
      SUBROUTINE csfrtz(w1,w2,w3,ccf,cc,sigma,tau,nx,ny)
      include 'undefined.h'
      INTEGER nx,ny
      DOUBLE PRECISION w1(nx,ny),w2(nx,ny),cc(nx,ny)
      DOUBLE PRECISION ccf(nx,ny),w3(nx,ny)
      DOUBLE PRECISION sigma,tau
      DOUBLE PRECISION h,sigh,d1x,d2x,d1y,d2y
      DOUBLE PRECISION nxu,nxd,nyu,nyd,div
      INTEGER i,j
      INTEGER nfilter, ifetch
c
      h = 1.d0/(nx-2)
      sigh = 0.5d0*tau**2*sigma/h**3
      do j=2,ny-1
         do i=2,nx-1
            nxu=dsqrt((ccf(i+1,j)-ccf(i,j))**2
     *           +0.0625d0*(ccf(i,j+1)-ccf(i,j-1)+ccf(i+1,j+1)
     *           -ccf(i+1,j-1))**2+1.d-50)
            nxd=dsqrt((ccf(i,j)-ccf(i-1,j))**2
     *           +0.0625d0*(ccf(i-1,j+1)-ccf(i-1,j-1)+ccf(i,j+1)
     *           -ccf(i,j-1))**2+1.d-50)
            nyu=dsqrt((ccf(i,j+1)-ccf(i,j))**2
     *           +0.0625d0*(ccf(i+1,j+1)-ccf(i-1,j+1)+ccf(i+1,j)
     *           -ccf(i-1,j))**2+1.d-50)
            nyd=dsqrt((ccf(i,j)-ccf(i,j-1))**2
     *           +0.0625d0*(ccf(i+1,j)-ccf(i-1,j)+ccf(i+1,j-1)
     *           -ccf(i-1,j-1))**2+1.d-50)           
           
            d1x=(ccf(i+1,j)-ccf(i,j))/nxu
            d2x=(ccf(i,j)-ccf(i-1,j))/nxd                  
            d1y=(ccf(i,j+1)-ccf(i,j))/nyu
            d2y=(ccf(i,j)-ccf(i,j-1))/nyd
            w3(i,j) = - (d1x-d2x+d1y-d2y)
         enddo
      enddo
c$$$       nfilter=0
c$$$       i=ifetch("divfilter",nfilter)
c$$$       do i=1,nfilter
c$$$          call copy(w2,w3,nx,ny)
c$$$          call filter(w2,w3,nx,ny) 
c$$$       enddo
c$$$c
c$$$       nfilter=0
c$$$       i=ifetch("gradfilter",nfilter)
c$$$      call copy(ccf,cc,nx,ny) 
c$$$      do i=1,nfilter
c$$$          call copy(w2,ccf,nx,ny)
c$$$          call filter(w2,ccf,nx,ny) 
c$$$       enddo
c$$$c       
c$$$         call makebcpf(ccf,nx,ny)
c$$$         do j=2,ny
c$$$            do i=2,nx
c$$$               w1(i,j)= sigh*(ccf(i,j)-ccf(i-1,j))*(w3(i,j) 
c$$$     *                 + w3(i-1,j))
c$$$               w2(i,j)= sigh*(ccf(i,j)-ccf(i,j-1))*(w3(i,j) 
c$$$     *                 + w3(i,j-1))
c$$$            enddo
c$$$         enddo              
      do j=2,ny
            do i=2,nx
               w1(i,j)= sigh*(ccf(i,j)-ccf(i-1,j))*(w3(i,j) 
     *                 + w3(i-1,j))
               w2(i,j)= sigh*(ccf(i,j)-ccf(i,j-1))*(w3(i,j) 
     *                 + w3(i,j-1))
            enddo
         enddo     
         call copy(w3,w1,nx,ny)
         call copy(ccf,w2,nx,ny)

c
c  calls boundary conditions for a homogenous field
c
         call bcvechom(w3,ccf,nx,ny)   
      return
      end

