c$$$    SURFER fluid interface simulation program
c$$$    Copyright (C) 2001 Stephane Zaleski and others
c$$$
c$$$    This library is free software; you can redistribute it and/or
c$$$    modify it under the terms of the GNU Lesser General Public
c$$$    License as published by the Free Software Foundation; either
c$$$    version 2.1 of the License, or (at your option) any later version.
c$$$
c$$$    This library is distributed in the hope that it will be useful,
c$$$    but WITHOUT ANY WARRANTY; without even the implied warranty of
c$$$    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
c$$$    Lesser General Public License for more details.
c$$$
c$$$    You should have received a copy of the GNU Lesser General Public
c$$$    License along with this library; if not, write to the Free Software
c$$$    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
c$$$
c$$$    Stephane Zaleski zaleski@lmm.jussieu.fr
c
c  **** ATTENTION : THIS PROGRAM USES FORTRAN NAME UP TO 10 CHARACTERS LONG ***
C
c
c
c
c
c
c
c
c                       o..............o
c                       :              :
c                   a(i-1,j)           :
c                   u(i,j)             :
c                *------>------*   S11, S22(i,j), pression, divergence
c                |      :      |   u**2, v**2, cc(i,j)
c                |      :      |       :
c                |     S12(i,j)| v(i,j):
c                ^      o..... ^.......o
c                |             | c(i,j-1) (c IS NOT cc) [a, c \simeq 1/\rho]
c                |             |
c                |             |
c                *------>------*
c   
c  
c      SKETCH OF TOP-BOTTOM BOUNDARY CONDITIONS
c   
c       *-----*------*------*------*  j =  ny   p(i,ny)
c       |     |      |      |      |
c   ....^.....^......^......^......^....        v(i,ny) = 0
c       |     |      |      |      |
c       |---------------------->---
c       |     |      |      |      |  j = ny-1
c       |     |      |      |      ^
c       |--------------------------|
c       |     |      |      |      |
c   
c   
c       |  :  |      |      |      |
c       |--:-----------------------
c       |  :  |      |      |      |
c       |  :  |      |      |  u(n-1,2)
c   >---*--:--*---------------->-- |  p(n-1,2)            | Boundary conditions
c       |  :  |      |      |      |                      |    u(i,1) = u(i,2)
c   ....^..:.......................^...  y = 0 v(i,2)     |    p(i,1) = p(i,2) 
c       |  :  |      |      |      |                      |    v(i,2) = 0
c   >---*-->--*------*------*-->-- *   j=1                   S12(i,2) = 0 
c       |  :  |      |      |      |   p(n-1,1)              S12(i,ny) = 0
c       ^  :  ^      ^      ^      ^   v(n-1,1)
c    v(1,1)
c   
c   Sites on or outside the dotted lines are used to force boundary conditions
c   There is also one dummy column on each side (not represented).
c
c
c   u,v(i,j)  the physical velocities *tau/h
c
c
      SUBROUTINE momentum(rhou,rhov,u,v,cc,p,a,c,ei,
     *                    S11,S22,S12,w1,w2,tau,mugas,muliq,
     *                    rhogas,g,nx,ny,outdiv,t)
      include 'undefined.h'
      include 'GP_decl.f'
      INTEGER nx,ny,outdiv,t,ifetch,dfetch
      INTEGER advectype, secondproj, capalg, harmonic
      DOUBLE PRECISION tau, h, mugas, muliq, rhogas
      DOUBLE PRECISION rhou(nx,ny), rhov(nx,ny)
      DOUBLE PRECISION u(nx,ny), v(nx,ny), cc(nx,ny), p(nx,ny)
      DOUBLE PRECISION S11(nx,ny),S12(nx,ny),S22(nx,ny)
      DOUBLE PRECISION w1(nx,ny),w2(nx,ny)
      DOUBLE PRECISION a(nx,ny), c(nx,ny), ei(nx,ny)
      INTEGER i,j,imax,jmax,cycles,ncycle,horgrav,relax_times
     * ,printres,relax_times_old,ncycle_old
      DOUBLE PRECISION mucst1ctr, mucst2ctr, mucst1, mucst2
      DOUBLE PRECISION smu1ctr, smu2ctr, smuc1, smuc2, spmul, spmug
c
      DOUBLE PRECISION rhocst1, rhocst1ov2
      DOUBLE PRECISION hi2, sumfield, fmodmax,normmean
      DOUBLE PRECISION tauh2,g,tau2h
      DOUBLE PRECISION s1,s2,t1,t2
      DOUBLE PRECISION findninf
      DOUBLE PRECISION epsilon,mineps,maxeps,xstdgrav,ystdgrav,norm_old
      double precision muauxef,cauxef

      INCLUDE 'cycling.f'

      secondproj=0
c
      horgrav=0
      i = ifetch("horgrav",horgrav)
      harmonic = GP_ifetch("harmonic",1,"WARNING")
c
c  Numerical constants
c
      h=1.d0/(nx-2)
      tauh2 = tau/(h*h)
      tau2h = tau**2/h
      hi2 = 1.d0/(h*h)
c
c Constants used to calculated local mu
c Mu constant 1, centered
c
      mucst1ctr = tauh2*mugas
c
c Mu constant 2, centered
c
      mucst2ctr = 0.25d0*tauh2*( muliq - mugas)
c
c Mu constants 1 and 2, not centered
c
      mucst1 = 2.d0*tauh2*mugas
      mucst2 = 2.d0*tauh2*(muliq - mugas)

      capalg=1
      i=ifetch("capalg",capalg)
   
c     
c Constants used to calculate local rho
c
      rhocst1 = 1.d0 - rhogas
      rhocst1ov2 =  .5d0*( 1.d0 - rhogas)
c
c  Gravity constants
c
      xstdgrav =  g*tau2h*horgrav
      ystdgrav =  g*tau2h*(1-horgrav) 
c
c  Addition of viscous stresses to previously computed surface tension stresses
c
      if(capalg.eq.1) then
         if(harmonic.eq.1) then
            do j=2,ny-1
               do i=2,nx-1
                  muauxef=2*tauh2/((cc(i,j)/muliq)+((1-cc(i,j))/mugas))
                  S11(i,j) = - S11(i,j)
     *                 + (muauxef)*(u(i+1,j) - u(i,j))
                  S22(i,j) = - S22(i,j)
     *                 + (muauxef)*(v(i,j+1) - v(i,j))
               enddo
            enddo
c     
            do j=2,ny
               do i=2,nx
                  cauxef=0.25*(cc(i,j)+cc(i-1,j)+cc(i,j-1)+cc(i-1,j-1))
                  muauxef=tauh2/((cauxef/muliq)+((1-cauxef)/mugas))
                  S12(i,j) = - S12(i,j)
     *                 + (muauxef)
     *                 * (u(i,j) - u(i,j-1) + v(i,j) - v(i-1,j))
               enddo
            enddo
         else
            do j=2,ny-1
               do i=2,nx-1
                  S11(i,j) = - S11(i,j)
     *                 + (mucst2*cc(i,j) + mucst1)*(u(i+1,j) - u(i,j))
                  S22(i,j) = - S22(i,j)
     *                 + (mucst2*cc(i,j) + mucst1)*(v(i,j+1) - v(i,j))
               enddo
            enddo
c     
            do j=2,ny
               do i=2,nx
                  S12(i,j) = - S12(i,j)
     *    + (mucst2ctr*(cc(i,j)+cc(i-1,j)+cc(i,j-1)+cc(i-1,j-1))
     *                 +  mucst1ctr)
     *                 * (u(i,j) - u(i,j-1) + v(i,j) - v(i-1,j))
               enddo
            enddo
      endif
c     
      call makebcsf(S11,S22,S12,nx,ny)
c
c Computation of 1/rho
c
      call afromc(a,c,ei,cc,rhocst1ov2,rhogas,nx,ny)
c
c Addition of viscous and surface tension stresses to velocity fields
c
c a, c are values of  1/rho

      do j=2,ny-1
         do i=2,nx-1
            w1(i,j) = u(i,j) + a(i-1,j)*(S12(i,j+1) - S12(i,j)
     *           + S11(i,j) - S11(i-1,j))
     *          + xstdgrav
c
            w2(i,j) = v(i,j) + c(i,j-1)*(S12(i+1,j) -S12(i,j)
     *            + S22(i,j) - S22( i,j-1)) 
     *            + ystdgrav
         enddo
      enddo
c     
      else if(capalg.le.4) then

c
c Computation of viscous stresses
c
         if(harmonic.eq.1) then
            stop 'no harmonic'
         else
            do j=2,ny-1
              do i=2,nx-1
                S11(i,j) = (mucst2*cc(i,j) + mucst1)*(u(i+1,j) - u(i,j))
                S22(i,j) = (mucst2*cc(i,j) + mucst1)*(v(i,j+1) - v(i,j))
              enddo
            enddo
c     
         do j=2,ny
            do i=2,nx
               S12(i,j) = 
     *              (mucst2ctr*(cc(i,j)+cc(i-1,j)+cc(i,j-1)+cc(i-1,j-1))
     *              +  mucst1ctr)
     *              * (u(i,j) - u(i,j-1) + v(i,j) - v(i-1,j))
            enddo
         enddo
      end if
c
         call makebcsf(S11,S22,S12,nx,ny)
c
c Computation of 1/rho
c
         call afromc(a,c,ei,cc,rhocst1ov2,rhogas,nx,ny)
c
c Addition of surface tension forces to velocity fields
c
c a, c are values of  1/rho
c
c       if (Gswitch.eq.0) then
         do j=2,ny-1
            do i=2,nx-1
               u(i,j) = u(i,j) + a(i-1,j)*w1(i,j)
               v(i,j) = v(i,j) + c(i,j-1)*w2(i,j)
            enddo
         enddo
c       else    
c         do j=2,ny-1
c            do i=2,nx-1
c               u(i,j) = u(i,j) + a(i-1,j)*Gx(i,j)*w1(i,j)
c               v(i,j) = v(i,j) + c(i,j-1)*Gy(i,j)*w2(i,j)
c            enddo
c         enddo
c        endif
         if(secondproj.eq.1) then
c
c Now   w2=divergence
c       w1=pressure
c
            do j=2,ny-1
               do i=2,nx-1
                  w2(i,j) = (u(i+1,j) - u(i,j) + v(i,j+1) - v(i,j))*hi2
               enddo
            enddo
      
            if (t .le. 1) then
               write (6,*) "divergence sum = ", sumfield(w2,nx,ny)
            endif

            if(mod(t,outdiv).eq.0) then 
c         write(6,*) "t,ncycle, div before=",t,ncycle,
c     $         h*fmodmax(w2,nx,ny,imax,jmax),imax,jmax
               write(6,*) "t,ncycle max=,div before=",t,ncycle,
     &              normmean(w2,nx,ny)
            endif

            call mglin(rhocst1ov2,rhogas,nx,ny)

c u = u-nondim tau / h  -> p = p-nondim tau**2 / h^2

            do j=2,ny-1
               do i=2,nx-1
                  u(i,j) = u(i,j) -  (p(i,j) - p(i-1,j))*a(i-1,j)
                  v(i,j) = v(i,j) -  (p(i,j) - p(i,j-1))*c(i,j-1)
               enddo
            enddo

            call makebcf(u,v,nx,ny)

            if(mod(t,outdiv).eq.0) then
               do j=2,ny-1
                  do i=2,nx-1
                     w2(i,j) = (u(i+1,j)-u(i,j)+v(i,j+1)-v(i,j))*hi2
                  enddo
               enddo

               write(6,*) "t,ncycles made=,div=",t,cycles,
     +              normmean(w2,nx,ny)
            endif
         endif
c END      if(secondproj.eq.1) then
c
c Addition of viscous stresses to velocity fields
c
         do j=2,ny-1
            do i=2,nx-1
               w1(i,j) = u(i,j) + a(i-1,j)*(S12(i,j+1) - S12(i,j)
     *              + S11(i,j) - S11(i-1,j))
c     *          + xstdgrav
c
               w2(i,j) = v(i,j) + c(i,j-1)*(S12(i+1,j) - S12(i,j)
     *              + S22(i,j) - S22( i,j-1)) 
     *              + ystdgrav
            enddo
         enddo
      else
         write(6,*) 'Surfer: momentum: unknown capalg parameter'
         STOP 'capalg'
      endif
C END      IF(CAPALG.EQ.1) THEN

      call makebcf(w1,w2,nx,ny)

      i=ifetch("advectiontype",advectype)
      if(i.eq.0) advectype=1
      if(advectype.eq.1) then 
c
c     Jie Li's upwind version
c     
         do j=2,ny-1
            do i=2,nx-1 
               t1=.5d0*(w2(i,j) + w2(i-1,j))
               t2=.5d0*(w2(i,j+1) + w2(i-1,j+1))
               s1=.5d0*(w1(i-1,j)+w1(i,j))
               s2=.5d0*(w1(i,j)+w1(i+1,j))
               u(i,j) =w1(i,j)
     *              +dmax1(t1,0.0d0)*w1(i,j-1)+dmin1(t1,0.0d0)*w1(i,j)
     *              -dmax1(t2,0.0d0)*w1(i,j)-dmin1(t2,0.0d0)*w1(i,j+1) 
     *              +dmax1(s1,0.0d0)*w1(i-1,j)+dmin1(s1,0.0d0)*w1(i,j)
     *              -dmax1(s2,0.0d0)*w1(i,j)-dmin1(s2,0.0d0)*w1(i+1,j)

               t1=0.5d0*(w1(i,j) + w1(i,j-1))
               t2=0.5d0*(w1(i+1,j) + w1(i+1,j-1))
               s1=0.5d0*(w2(i,j-1)+w2(i,j))
               s2=0.5d0*(w2(i,j)+w2(i,j+1))
               v(i,j) =w2(i,j)
     *              +dmax1(t1,0.0d0)*w2(i-1,j)+dmin1(t1,0.0d0)*w2(i,j)
     *              -dmax1(t2,0.0d0)*w2(i,j)-dmin1(t2,0.0d0)*w2(i+1,j)
     *              +dmax1(s1,0.0d0)*w2(i,j-1)+dmin1(s1,0.0d0)*w2(i,j)
     *              -dmax1(s2,0.0d0)*w2(i,j)-dmin1(s2,0.0d0)*w2(i,j+1)
            enddo
         enddo
      else if(advectype.eq.2) then
c
c  Centered
c
         do j=2,ny-1
            do i=2,nx-1
               u(i,j) = w1(i,j)+ 0.25d0*(
     *              (w1(i,j) + w1(i,j-1))*(w2(i,j) + w2(i-1,j))
     *              -  (w1(i,j+1) + w1(i,j))*(w2(i,j+1) + w2(i-1,j+1))
     *              + (w1(i-1,j)+w1(i,j))**2 - (w1(i,j)+w1(i+1,j))**2)
               v(i,j) = w2(i,j) + 0.25d0*(
     *              (w1(i,j) + w1(i,j-1))*(w2(i,j) + w2(i-1,j))
     *              -  (w1(i+1,j) + w1(i+1,j-1))*(w2(i+1,j) + w2(i,j))
     *              + (w2(i,j-1)+w2(i,j))**2 - (w2(i,j)+w2(i,j+1))**2)
            enddo
         enddo

      else 
         do j=2,ny-1
            do i=2,nx-1
               u(i,j) = w1(i,j)
               v(i,j) = w2(i,j)
            enddo
         enddo
      endif
c
      call makebcf(u,v,nx,ny)
c
c Now   w2=divergence
c       w1=pressure
c
      do j=2,ny-1
         do i=2,nx-1
            w2(i,j) = ( u(i+1,j) - u(i,j) + v(i,j+1) - v(i,j))*hi2
         enddo
      enddo

      if (t .le. 1) then
         write (6,*) "divergence sum = ", sumfield(w2,nx,ny)
      endif

      if(mod(t,outdiv).eq.0) then 
c         write(6,*) "t,ncycle, div before=",t,ncycle,
c     $         h*fmodmax(w2,nx,ny,imax,jmax),imax,jmax
       write(6,*) "t,ncycle max=,div before=",t,ncycle,
     & normmean(w2,nx,ny)
	endif

      call mglin(rhocst1ov2,rhogas,nx,ny)

      do j=2,ny-1
         do i=2,nx-1
c            print*,'i,j,p',i,j,p(i,j),u(i,j),v(i,j)
            u(i,j) = u(i,j) -  (p(i,j) - p(i-1,j))*a(i-1,j)
            v(i,j) = v(i,j) -  (p(i,j) - p(i,j-1))*c(i,j-1)
c            print*,'i,j,p',u(i,j),v(i,j)
         enddo
      enddo
c
      call makebcf(u,v,nx,ny)
c
      if(mod(t,outdiv).eq.0) then
         do j=2,ny-1
            do i=2,nx-1
               w2(i,j) = (u(i+1,j)-u(i,j)+v(i,j+1)-v(i,j))*hi2
            enddo
         enddo
         call makebcresf(w2,nx,ny)
         write(6,*) "t,ncycles made=,div=",t,cycles,normmean(w2,nx,ny)

      endif
      return
c
 100  format(g10.7)
      end









