c   $Id: ini_conditions.f,v 1.1 2002/02/07 16:55:49 zaleski Exp $
c   (c) S. Zaleski, CNRS, UPMC
c
c   $Author: zaleski $
c
      SUBROUTINE ini1disk(u,v,c,p,xvel,yvel,tau,nx,ny)
      include 'undefined.h'
      INTEGER nx , ny, dfetch,i, ifetch
      DOUBLE PRECISION u(nx,ny), v(nx,ny), c(nx,ny), p(nx,ny)
      DOUBLE PRECISION xvel,yvel,xc,yc,tau
      INTEGER idrop, ibubble
      REAL*8 radius

      idrop=0
      i=ifetch("drop",idrop)
      ibubble=0
      i=ifetch("bubble",ibubble)

      if(ibubble+idrop.eq.2)  stop "can t have both drop and bubble"
      if(ibubble+idrop.eq.0) stop "Not a drop/bubble"

      i=dfetch("radius",radius)
      write(6,*) "radius=",radius
      xc=0.d0
      yc=0.d0
      i=dfetch("xcenter",xc) 
      i=dfetch("ycenter",yc) 
c      call diskpre(u,v,c,p,xvel,yvel,xc,yc,radius,tau,nx,ny)
      call creatdisk(u,v,c,p,xvel,yvel,xc,yc,idrop,radius,tau,nx,ny)
      return
      end

      SUBROUTINE addlayer(u,v,c,p,xvel,tau,nx,ny)
      include 'undefined.h'
      INTEGER nx , ny, dfetch,i,j, ifetch
      DOUBLE PRECISION u(nx,ny), v(nx,ny), c(nx,ny), p(nx,ny)
      DOUBLE PRECISION xvel,tau,y,h
      INTEGER idrop
      REAL*8 width

      idrop=0
      i=ifetch("drop",idrop)
      width=0.0
      i=dfetch("layer-width",width)
c      if(idrop.ne.1.and.width.gt.0.)  stop "must have drop"
      h = 1.d0/(nx-2)
      do j=1,ny
         do i=1,nx
            y = h*((j*1.)-1.5)
            if(y .le. width) then
               c(i,j) = 1.d0
            endif
         enddo
      enddo
      call makebccf(c,nx,ny) 
      return
      end

      SUBROUTINE creatdisk(u,v,c,p,xvel,yvel,xc,yc,idrop,r,tau,nx,ny)
      include 'undefined.h'
      INTEGER nx,ny
      DOUBLE PRECISION u(nx,ny), v(nx,ny), c(nx,ny), p(nx,ny)
      DOUBLE PRECISION xvel, yvel,xc,yc,r,x,y, h, tau
      DOUBLE PRECISION radius, gp_dfetch
      INTEGER i,j, idrop
      h = 1.d0/(nx-2)
      do j=1,ny
         do i=1,nx
            y = h*(j - ny/2) - yc
            x = h*(i - nx/2) - xc
            if(x*x + y*y .le. r*r) then
               c(i,j) = 1.d0*idrop
               u(i,j) = xvel
               v(i,j) = yvel
            else
               u(i,j) =0.d0
               v(i,j) =0.d0
               c(i,j) = (1 - idrop)*1.d0
            endif
         enddo
      enddo
      call makebccf(c,nx,ny) 
      do i=2,nx-1
	do j=2,ny-1
	   u(i,j) = u(i,j) *tau/h
	   v(i,j) = v(i,j) *tau/h
        enddo
      enddo

c  override C with RS's ellipse
c      call doellipse(c,nx,ny)

      radius=gp_dfetch("radius",1.,"SEVERE")
      if(radius.ne.gp_dfetch("a1",1.,"SEVERE")) STOP 'a1.ne.radius'
      return
      end

      SUBROUTINE inisquare(u,v,c,p,tau,xvel,yvel,xc,yc,r,nx,ny)
      include 'undefined.h'
      INTEGER nx,ny
      DOUBLE PRECISION u(nx,ny), v(nx,ny), c(nx,ny), p(nx,ny)
      DOUBLE PRECISION xvel, yvel,xc,yc,r,x,y,tau,h
      INTEGER i,j
      h = 1.d0/(nx - 2)
      do j=1,ny
         do i=1,nx
            y = float(j -nx/2)/(nx-2) - yc
            x = float(i - ny/2)/(nx-2) - xc
            c(i,j) = 0.d0
            u(i,j) = xvel*tau/h
            v(i,j) = yvel*tau/h
            p(i,j) = 0.d0
            if( dmax1(dabs(x),dabs(y)) .le. r) then
               c(i,j) = 1.d0
            endif
         enddo
      enddo
      return
      end


      SUBROUTINE inirotrec(u,v,c,p,tau,xvel,yvel,xc,yc,r,nx,ny)
      include 'undefined.h'
      INTEGER nx,ny, ifetch, dfetch, invert,tmax
      DOUBLE PRECISION u(nx,ny), v(nx,ny), c(nx,ny), p(nx,ny)
      DOUBLE PRECISION xvel, yvel,xc,yc,r,x,y,tpi,tau,h,arot
      INTEGER i,j
      h = 1.d0/(nx - 2)
      i = ifetch("tmaxrot",tmax)
      arot=1.0
      i = dfetch("anglerot",arot)
      tpi = arot*dacos(0.d0)*4.d0*(nx-2)/tmax
      invert=1
      i = ifetch("invert",invert)
      write(6,*) "tpi=",tpi
      do j=1,ny
         do i=1,nx
            y = float(j -nx/2)/(nx-2) - yc
            x = float(i - ny/2)/(nx-2) - xc
            c(i,j) = REAL(invert - 1)
            u(i,j) = (-tpi)*y
            v(i,j) =  tpi*x
            p(i,j) = 0.d0
            if(dabs(x) .le. 1.66666666666d0*r
     $                .and.dabs(y).lt.r) then
               c(i,j) = REAL(invert)
            endif
         enddo
      enddo
      return
      end


      SUBROUTINE inizero(u,v,c,p,tau,nx,ny)
      include 'undefined.h'
      INTEGER nx,ny
      DOUBLE PRECISION u(nx,ny), v(nx,ny), c(nx,ny), p(nx,ny)
      DOUBLE PRECISION tau,r1,h
      INTEGER i,j
      r1=0.3056d0
      h=1.d0/(nx-2)
      do j=1,ny
         do i=1,nx
            c(i,j)= 0.d0
            u(i,j)= 0.d0
            v(i,j)= 0.d0
            p(i,j)= 0.d0
         enddo
      enddo
      return
      end

