#include <stdio.h>
#include <stdlib.h>

void forcefile_(double *u, double *v, double *c, int *nx, int *ny, int *nz, int *t)
{
  int i, j, k, nvar = 3;
  float val;
  char s[256];
  int nb;
  FILE *fptr;

  

  sprintf(s, "%s.%d", "force.datb",*t);
  fptr = fopen(s, "wb");

  fwrite(&*nx, sizeof(int), 1, fptr);
  fwrite(&*ny, sizeof(int), 1, fptr);
  fwrite(&*nz, sizeof(int), 1, fptr);
  fwrite(&nvar, sizeof(int), 1, fptr);

  sprintf(s, "u");
  fwrite(s, sizeof(char), 256, fptr);
  sprintf(s, "v");
  fwrite(s, sizeof(char), 256, fptr);
  sprintf(s, "c");
  fwrite(s, sizeof(char), 256, fptr);

  for (i = 0; i < *nx; i++)
    for (j = 0; j < *ny; j++)
      for (k = 0; k < *nz; k++) {
        val = (u[i + (*nx)*j + (*nx)*(*ny)*k]);
        fwrite(&val, sizeof(float), 1, fptr);
      }

  for (i = 0; i < *nx; i++)
    for (j = 0; j < *ny; j++)
      for (k = 0; k < *nz; k++) {
        val = (v[i + (*nx)*j + (*nx)*(*ny)*k]);
        fwrite(&val, sizeof(float), 1, fptr);
      }

  for (i = 0; i < *nx; i++)
    for (j = 0; j < *ny; j++)
      for (k = 0; k < *nz; k++) {
        val = (c[i + (*nx)*j + (*nx)*(*ny)*k]);
        fwrite(&val, sizeof(float), 1, fptr);
      }
  fclose(fptr);
}
