c$$$    SURFER fluid interface simulation program
c$$$    Copyright (C) 2001 Stephane Zaleski and others
c$$$
c$$$    This library is free software; you can redistribute it and/or
c$$$    modify it under the terms of the GNU Lesser General Public
c$$$    License as published by the Free Software Foundation; either
c$$$    version 2.1 of the License, or (at your option) any later version.
c$$$
c$$$    This library is distributed in the hope that it will be useful,
c$$$    but WITHOUT ANY WARRANTY; without even the implied warranty of
c$$$    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
c$$$    Lesser General Public License for more details.
c$$$
c$$$    You should have received a copy of the GNU Lesser General Public
c$$$    License along with this library; if not, write to the Free Software
c$$$    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
c$$$
c$$$    Stephane Zaleski zaleski@lmm.jussieu.fr
c
c   Our implementation of the original Brackbill-Kothe-Zemach 
c   algorithm 
c
c$$$@ARTICLE{brackbill92, 
c$$$	author="J.U. Brackbill  and  D. B. Kothe and C. Zemach ",
c$$$        title="A Continuum Method for Modeling Surface Tension",
c$$$        journal="J. Comput. Phys.",
c$$$        year="1992",
c$$$        volume="100",
c$$$        pages="335-354"}
c$$$
c
c
c   On input:
c   
c        cc          (filtered) volume fractions
c        S1         arbitrary nx*ny array;
c        S2              "
c        w1             "
c        w2        
c        sigma     surface tension coefficient.
c        
c   
c   On output
c   
c        w2 first component of force multiplied by tau/h
c        cc  second "   "  "  "  "  "
c        in momentum.f  at locations described on figure.
c   
      SUBROUTINE csfbkz(S1,S2,w1,w2,cc,sigma,tau,nx,ny)
      include 'undefined.h'
      INTEGER nx,ny
      DOUBLE PRECISION S1(nx,ny),S2(nx,ny),cc(nx,ny)   
      DOUBLE PRECISION w1(nx,ny),w2(nx,ny)
      DOUBLE PRECISION sigma,tau
      DOUBLE PRECISION h,sigh,d1x,d2x,d1y,d2y
      DOUBLE PRECISION nxu,nxd,nyu,nyd,div
      INTEGER i,j
c
      h = 1.d0/(nx-2)
      sigh =.5d0*tau**2*sigma/h**3
      do j=2,ny-1
         do i=2,nx-1
            nxu=dsqrt((cc(i+1,j)-cc(i,j))**2
     *           +0.0625d0*(cc(i,j+1)-cc(i,j-1)+cc(i+1,j+1)
     *           -cc(i+1,j-1))**2+1.d-50)
            nxd=dsqrt((cc(i,j)-cc(i-1,j))**2
     *           +0.0625d0*(cc(i-1,j+1)-cc(i-1,j-1)+cc(i,j+1)
     *           -cc(i,j-1))**2+1.d-50)
            nyu=dsqrt((cc(i,j+1)-cc(i,j))**2
     *           +0.0625d0*(cc(i+1,j+1)-cc(i-1,j+1)+cc(i+1,j)
     *           -cc(i-1,j))**2+1.d-50)
            nyd=dsqrt((cc(i,j)-cc(i,j-1))**2
     *           +0.0625d0*(cc(i+1,j)-cc(i-1,j)+cc(i+1,j-1)
     *           -cc(i-1,j-1))**2+1.d-50)           
           
            d1x=(cc(i+1,j)-cc(i,j))/nxu
            d2x=(cc(i,j)-cc(i-1,j))/nxd      
            d1y=(cc(i,j+1)-cc(i,j))/nyu
            d2y=(cc(i,j)-cc(i,j-1))/nyd
            div= -(d1x-d2x+d1y-d2y)

            S1(i,j)=sigh*(cc(i+1,j)-cc(i-1,j))*div
            S2(i,j)=sigh*(cc(i,j+1)-cc(i,j-1))*div
         enddo
      enddo 
      call bcvechom(S1,S2,nx,ny)
      do j=2,ny-1
         do i=2,nx-1
            w1(i,j)=.5d0*(S1(i,j)+S1(i-1,j))
            w2(i,j)=.5d0*(S2(i,j)+S2(i,j-1))
         enddo
      enddo
      call copy(cc,w2,nx,ny)
      call copy(w2,w1,nx,ny)
      return
      end

