c$$$    SURFER fluid interface simulation program
c$$$    Copyright (C) 2001 Stephane Zaleski and others
c$$$
c$$$    This library is free software; you can redistribute it and/or
c$$$    modify it under the terms of the GNU Lesser General Public
c$$$    License as published by the Free Software Foundation; either
c$$$    version 2.1 of the License, or (at your option) any later version.
c$$$
c$$$    This library is distributed in the hope that it will be useful,
c$$$    but WITHOUT ANY WARRANTY; without even the implied warranty of
c$$$    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
c$$$    Lesser General Public License for more details.
c$$$
c$$$    You should have received a copy of the GNU Lesser General Public
c$$$    License along with this library; if not, write to the Free Software
c$$$    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
c$$$
c$$$    Stephane Zaleski zaleski@lmm.jussieu.fr
c
      SUBROUTINE afromc(a,c,ei,cc,rhocst1ov2,rhogas,nx,ny)
      include 'undefined.h'
      INTEGER nx,ny
      DOUBLE PRECISION a(nx,ny),c(nx,ny),ei(nx,ny),cc(nx,ny)
      DOUBLE PRECISION rhocst1ov2,rhogas ,dmax1,dmin1,cc1,cc2,cc3
      INTEGER i,j,ifetch,capdens

      capdens=0
      i=ifetch("capdens",capdens)
      if(capdens.eq.1) then 
         do j=1,ny-1
            do i=1,nx-1
               cc1 = dmax1(0.d0, dmin1(cc(i,j),1.d0))
               cc2 = dmax1(0.d0, dmin1(cc(i+1,j),1.d0))
               cc3 = dmax1(0.d0, dmin1(cc(i,j+1),1.d0))
               a(i,j) = 1.d0/(rhocst1ov2*(cc1 + cc2) + rhogas)
               c(i,j) = 1.d0/(rhocst1ov2*(cc1 + cc3) + rhogas)
            enddo
         enddo
      else
         do j=1,ny-1
            do i=1,nx-1
               a(i,j) = 1.d0/(rhocst1ov2*(cc(i,j) + cc(i+1,j)) + rhogas)
               c(i,j) = 1.d0/(rhocst1ov2*(cc(i,j) + cc(i,j+1)) + rhogas)
            enddo
         enddo
      endif
      do j=2,ny-1
         do i=2,nx-1
            ei(i,j) = 1.d0/(a(i,j) + a(i-1,j) + c(i,j) + c(i,j-1))
         enddo
      enddo
      return
      end






