#include <stdio.h>
#include <math.h>
#include "myset.h"
#include "main.h"

/* ------------------------------------------------------------------- *
 * PROGRAM TO MOVE AN ELLIPSE IN A LAGRANGIAN WAY                      *
 * ------------------------------------------------------------------- */
main()
{
/* declarations */

  FILE *fp, *fr;
  int i,nx=NMX,ny=NMY,nreal,debug,nciam;
  int npt,nfig,nstep,npip;
  double xc,yc,a2,b2,a1,b1,ux,vy,sumcc;
  double cfl,period;
  double *x0,*y0,*alpha,*timeh;
  double *xx, *yy, **cc, **cd, **u, **v, **a, **b, **c, **d,**PSI,*cxsum;
  double **u1,**v1;
  char buf [128];
  SEGS **ale, **ric;
  MARK_PTR **mar;
  MARK *aux;

  /* allocate variables */
  npt = MAX(NPTS,10000);
  xx = (double *) vector(1,npt,sizeof(double),"xx");
  yy = (double *) vector(1,npt,sizeof(double),"yy");
  cc = (double **) mat2D(1,nx,1,ny,sizeof(double),"cc");
  ale = (SEGS **) mat2D(1,nx,1,ny,sizeof(SEGS),"ale");
  ric = (SEGS **) mat2D(1,nx,1,ny,sizeof(SEGS),"ric");
  mar = (MARK_PTR **) mat2D(1,nx,1,ny,sizeof(MARK_PTR),"mar");
  aux = (MARK *) vector(1,nx,sizeof(MARK),"aux");
  cd = (double **) mat2D(1,nx,1,ny,sizeof(double),"cd");
  u1 = (double **) mat2D(1,nx,1,ny,sizeof(double),"u1");
  v1 = (double **) mat2D(1,nx,1,ny,sizeof(double),"v1");
  u = (double **) mat2D(1,nx,1,ny,sizeof(double),"u");
  v = (double **) mat2D(1,nx,1,ny,sizeof(double),"v");
  a = (double **) mat2D(1,nx,1,ny,sizeof(double),"a");
  b = (double **) mat2D(1,nx,1,ny,sizeof(double),"b");
  c = (double **) mat2D(1,nx,1,ny,sizeof(double),"c");
  d = (double **) mat2D(1,nx,1,ny,sizeof(double),"d");
  PSI = (double **) mat2D(1,nx+1,1,ny+1,sizeof(double),"PSI");
  cxsum = (double *) vector(1,ny,sizeof(double),"cxsum");
  x0 = (double *) vector(1,150,sizeof(double),"x0");
  y0 = (double *) vector(1,150,sizeof(double),"y0");
  alpha = (double *) vector(1,150,sizeof(double),"alpha");
  timeh = (double *) vector(1,1000,sizeof(double),"times");

  /* ***************************************************************** *
   * LIN33 representation: determine the segments and draw them       *
SZ is there advection ? 
   * ***************************************************************** */

  fprintf(stderr,"\n-------------    BEGIN LIN33    -------------\n");
  fprintf(stderr,"\n-------------    BEGIN 3PTS    -------------\n");
  

  copy(cc,cd,nx,ny);
  
  get_area(cd,nx,ny);  /* computes total area */
  
  ini_ale(cd,ale,nx,ny);  /* Initializes ale by marking cut cells */
  lin33(cd,ale,nx,ny,0);
  get_error(cc,cd,nx,ny,0);   /* find difference between cc and cd */

  points(cd,ale,nx,ny,debug);  /* computes curvature ? */

  fprintf(stderr,"\n-------------    END LIN33     -------------\n");
  */  

  /* ***************************************************************** *
   * CLOSE                                                             *
   * ***************************************************************** */
  (void) fprintf(fp,"\n$ END\n");
  (void) fclose(fp);
  (void) fclose(fr);
  fprintf(stderr,"\n-------------        END        -------------\n\n");
}

/* ------------------------------------------------------------------- */
void arc(double *x, double *y, double cc, int ipt, SEGS *ptr,
         int debug, int ii, int jj)
{
  int i,i_check;
  double a11,a12,a13,a22,a23,a33,b1,b2,b3,tmp;
  double det,top,a,b,c,x0,y0,r2;
  double xs,ys,xe,ye,x1,y1;
  double area_diff,hr,base;

  xs = ptr->x1;  
  ys = ptr->y1;
  xe = ptr->x2;  
  ye = ptr->y2;
  
  a11=a12=a13=a22=a23=a33=b1=b2=b3=0.0;
  
  for (i=0; i<ipt; i++) {
    a11 += 1.0; 
    a12 += y[i];
    a13 += x[i];
    a22 += y[i]*y[i];
    a23 += y[i]*x[i];
    a33 += x[i]*x[i];
    tmp = x[i]*x[i] + y[i]*y[i];
    b1 -= tmp;
    b2 -= y[i]*tmp;
    b3 -= x[i]*tmp;
  }
  
  det = a11*(a22*a33-a23*a23) - a12*(a12*a33-a13*a23) +
    a13*(a12*a23-a22*a13);
  /*
  if (debug) {
  fprintf(stderr,"cell: (%d,%d), points: %d\n",ii,jj,ipt);
  fprintf(stderr,"det circle: %e\n",det);
  fprintf(stderr,"det line  : %e\n",a22*a33 - a23*a23);
  }
  */

  /* DEFAULT: straight line */
  x[0] = xs;
  y[0] = ys;
  x[1] = xe;
  y[1] = ye;
  x[2] = 0.5*(xs+xe);
  y[2] = 0.5*(ys+ye);

  if (fabs(det) > 1.e-5) {
    top = b1*(a22*a33-a23*a23) - a12*(b2*a33-b3*a23) +
      a13*(b2*a23-a22*b3);
    c = top/det;
    top = a11*(b2*a33-b3*a23) - b1*(a12*a33-a13*a23) +
      a13*(a12*b3-b2*a13);
    b = top/det;
    top = a11*(a22*b3-b2*a23) - a12*(a12*b3-a13*b2) +
      b1*(a12*a23-a22*a13);
    a = top/det;
    
    /*
      x0 = -a/2.;
      y0 = -b/2.;
      r2 = x0*x0 + y0*y0 - c;
      
      if (debug) {
      fprintf(stderr,"det,a,b,c: %e, %e, %e, %e\n",det,a,b,c);
      fprintf(stderr,"x0,y0,r^2: %e, %e, %e\n",x0,y0,r2);
      }
    */

    /* get intersections and middle point */
    i = get_intersection(xs,ys,a,b,c,&x1,&y1);
    if (i) {
      x[0] = x1;
      y[0] = y1;
    }
    else {
      /*
      fprintf(stderr,"problem with 1st intersection!: %d,%d\n",ii,jj);
      fprintf(stderr,"cc,i: %e,%d\n",cc,i);
      */
    }
    i = get_intersection(xe,ye,a,b,c,&x1,&y1);
    if (i) {
      x[1] = x1;
      y[1] = y1;
    }
    else {
      /*
      fprintf(stderr,"problem with 2nd intersection!: %d,%d\n",ii,jj);
      fprintf(stderr,"cc,i: %e,%d\n",cc,i);
      */
    }

    x[2] = 0.5*(x[0]+x[1]);
    y[2] = 0.5*(y[0]+y[1]);
    
    /* area correction */
    area_diff = cc - area2(x,y);
    base = sqrt( (x[0]-x[1])*(x[0]-x[1]) + (y[0]-y[1])*(y[0]-y[1]) );
    base = MAX(base,NOT_ZERO);
    hr = 2.0*area_diff/base;

    a11 = y[1] - y[0];
    a22 = x[0] - x[1];
    a33 = y[0]*x[1] - x[0]*y[1];
    x[2] = x[2] + hr*a11/base;
    y[2] = y[2] + hr*a22/base;
    
    /*
    if (debug) 
      fprintf(stderr,"area_diff,base,hr: %e, %e, %e\n",area_diff,base,hr);
    */

    /* correct if x[2] (y[2]) < 0. or > 1. and if |hr|/base > FRAC_SEG; */
    a12 = MIN(x[2],y[2]);
    a13 = MAX(x[2],y[2]);
    i_check = 0;
    if (fabs(hr) > FRAC_SEG*base)
      i_check = 1;
    if (a12 < 0.0)
      i_check = 1;
    if (a13 > 1.0)
      i_check = 1;

    /* curvature index */
    b1 = 0.0;
    b2 = fabs(x[0]-x[1]);
    b3 = fabs(y[0]-y[1]);
    x0 = 0.5*(x[0]+x[1]);
    y0 = 0.5*(y[0]+y[1]);
    if (b2 >= b3) {
      i = get_root(a,b,c,x0,y0,x0,&b3);
      b2 = x0;
    }
    else {
      i = get_root(b,a,c,y0,x0,y0,&b2);
      b3 = y0;
    }

    if (i)
      b1 = a11*b2 + a22*b3 + a33;
    b2 = a11*x[2] + a22*y[2] + a33;
    if (b1*b2 <= 0. AND fabs(hr) > FRAC_CUR*base) 
      i_check = 1;

    if (b1*b2 <= 0.0) {
      i_check = 0;
      x[0] = xs;
      y[0] = ys;
      x[1] = xe;
      y[1] = ye;
      x[2] = 0.5*(xs+xe);
      y[2] = 0.5*(ys+ye);
    }

    /*
    if (debug) 
      fprintf(stderr,"b1,b2,hr/base,fr-cur: %e, %e, %e, %e\n",b1,b2,
              hr/base,FRAC_CUR);
    */


    while (i_check) { 
      x[0] = x[0] + 0.3*(xs-x[0]);
      y[0] = y[0] + 0.3*(ys-y[0]);
      a11 = MIN(x[0],1.-x[0]);
      a22 = MIN(y[0],1.-y[0]);
      if (a11<a22)
      tmp =modf(x[0]+0.5,&x[0]);
      else
      tmp =modf(y[0]+0.5,&y[0]);

      x[1] = x[1] + 0.3*(xe-x[1]);
      y[1] = y[1] + 0.3*(ye-y[1]);
      a11 = MIN(x[1],1.-x[1]);
      a22 = MIN(y[1],1.-y[1]);
      if (a11<a22)
      tmp =modf(x[1]+0.5,&x[1]);
      else
      tmp =modf(y[1]+0.5,&y[1]);

      x[2] = 0.5*(x[0]+x[1]);
      y[2] = 0.5*(y[0]+y[1]);
      
      area_diff = cc - area2(x,y);
      base = sqrt( (x[0]-x[1])*(x[0]-x[1]) + (y[0]-y[1])*(y[0]-y[1]) );
      base = MAX(base,NOT_ZERO);
      hr = 2.0*area_diff/base;

      /*      
      if (debug) 
	fprintf(stderr,"COR:area_diff,base,hr: %e, %e, %e\n",area_diff,base,hr);
      */
      a11 = y[1] - y[0];
      a22 = x[0] - x[1];
      a33 = y[0]*x[1] - x[0]*y[1];
      x[2] = x[2] + hr*a11/base;
      y[2] = y[2] + hr*a22/base;
      
      a12 = MIN(x[2],y[2]);
      a13 = MAX(x[2],y[2]);
      i_check = 0;
      if (fabs(hr) > FRAC_SEG*base)
        i_check = 1;
      if (a12 < 0.0)
        i_check = 1;
      if (a13 > 1.0)
        i_check = 1;
      b2 = a11*x[2] + a22*y[2] + a33;
      if (b1*b2 < 0. AND fabs(hr) > FRAC_CUR*base)
        i_check = 1;
    }

    /*    
    if (debug) {
      fprintf(stderr,"middle area diff: %e\n",area_diff);
      fprintf(stderr,"base,hr: %e, %e\n",base,hr);
      fprintf(stderr,"a,b,c: %e, %e, %e\n",a,b,c);
      fprintf(stderr,"x0,y0: %f, %f\n",x[0],y[0]);
      fprintf(stderr,"x1,y1: %f, %f\n",x[1],y[1]);
      fprintf(stderr,"x2,y2: %f, %f\n",x[2],y[2]);
      fprintf(stderr,"final area diff: %e\n",fabs(cc-area3(x,y)));
    }
    */
  }
  
  /*
  else if (debug) {
    fprintf(stderr,"STRAIGHT LINE(?): %e, POINTS: %d\n",det,ipt);
    fprintf(stderr,"x0,y0: %f, %f\n",x[0],y[0]);
    fprintf(stderr,"x1,y1: %f, %f\n",x[1],y[1]);
    fprintf(stderr,"x2,y2: %f, %f\n",x[2],y[2]);
  }
  */
  return;
}




