#include <stdio.h>
#include <math.h>
#include "myset.h"
#include "general.h"
#define FRAC_SEG 0.2
#define FRAC_CUR 0.01

void arc(double *,double *,double,int,SEGS *,int, int, int);
int get_root(double,double,double,double,double,double,double *);
int get_intersection(double,double,double,double,double,double *,double *);
double area2(double *, double *);
double area3(double *, double *);
void make_bc_pts(SEGS **,int,int);
/* ------------------------------------------------------------------- */
void kappa(double **c, double **kappa; SEGS **ale,int nx, int ny, int debug)
{
  int i,j,ind[3][3],i1,j1,ii,jj,k,ipt,ncell,nl,n1,n2,n3;
  double x[36],y[36],ddd,dist,dist_1,dist_2,dist_3,d1,d2,d3,rx,ry;
  double x1,y1,x2,y2,xs,xe,ys,ye,xs_c,xe_c,ys_c,ye_c,xc,yc,xm,ym;
  SEGS *ptr_c,*ptr;

  /* define midpoint */
  for (i=1; i<=nx; i++) 
    for (j=1; j<=ny; j++) {
      ptr_c = &ale[i][j];
     if (ptr_c->crossed) {
       ptr_c->x3 = 0.5*(ptr_c->x1 + ptr_c->x2);      
       ptr_c->y3 = 0.5*(ptr_c->y1 + ptr_c->y2);      
     }
    }

  /* distances for best fit */
  dist_1 = 0.2*0.2;
  dist_2 = 0.5*0.5;
  
  for (i=2; i<=nx-1; i++) 
    for (j=2; j<=ny-1; j++) {
      ptr_c = &ale[i][j];
      
      if (ptr_c->crossed) {
	
        if (debug) {
          fprintf(stderr,"****************************\n");
          fprintf(stderr,"cell: (%d,%d), cc: %e\n",i,j,c[i][j]);
        }
	
        /* get local indices array */
        ncell = 0;
        for (i1=0; i1<=2; i1++) { 
	  ptr = &ale[i+i1-1][j-1];
          for (j1=0; j1<=2; j1++) { 
	    ind[i1][j1] = ptr->crossed;
	    ncell += ind[i1][j1];
	    ptr++;
	  }
	}
	
        if (debug) {
          fprintf(stderr,"top line: %d, %d, %d\n",ind[0][2],ind[1][2],ind[2][2]);
          fprintf(stderr,"cen line: %d, %d, %d\n",ind[0][1],ind[1][1],ind[2][1]);
          fprintf(stderr,"bot line: %d, %d, %d\n",ind[0][0],ind[1][0],ind[2][0]);
        }
	
        /* determine general direction */
        xs_c = ptr_c->x1;
        ys_c = ptr_c->y1;
        xe_c = ptr_c->x2;
        ye_c = ptr_c->y2;
	xc =  ptr_c->x3;
	yc =  ptr_c->y3;
	 
        d1 = (ye_c-ys_c)*(xs_c-xe_c);
        if (fabs(d1) < 1.e-3)
          ;
        else if (d1 < 0.0) {
          ind[0][2] *= -1;
	  ind[2][0] *= -1;
	}
        else {
          ind[0][0] *= -1;
	  ind[2][2] *= -1;
	}


        /* add central cell */
        ind[1][1] = 0;
        ipt = 0;
        x[ipt] = xc;
        y[ipt] = yc;
        ipt++;
        x[ipt] = xc;
        y[ipt] = yc;
        ipt++;
	x[ipt] = xs_c;
	y[ipt] = ys_c;
	ipt++;
	x[ipt] = xe_c;
	y[ipt] = ye_c;
	ipt++;

	rx = MIN(2.0-xc,xc+1.0);
	ry = MIN(2.0-yc,yc+1.0);
	dist_3 = MIN(rx*rx,ry*ry) + 0.03;

        /* add surrounding cells */
        for (i1=0; i1<=2; i1++) 
          for (j1=0; j1<=2; j1++) 
            if (ind[i1][j1]) {
              if (debug) 
                fprintf(stderr,"add lateral cell: (%d,%d)\n",i1-1,j1-1);
              ptr = &ale[i+i1-1][j+j1-1]; 
              xs = ptr->x1 + i1 - 1;
              ys = ptr->y1 + j1 - 1;
              xe = ptr->x2 + i1 - 1;
              ye = ptr->y2 + j1 - 1;
              xm = ptr->x3 + i1 - 1;
              ym = ptr->y3 + j1 - 1;
	      
              nl = 0;
              ddd = (xs-xe)*(xs-xe) + (ys-ye)*(ys-ye);
              if (ddd > dist_1)
                nl++;
              d1 = (xs-xc)*(xs-xc) + (ys-yc)*(ys-yc);
              d2 = (xe-xc)*(xe-xc) + (ye-yc)*(ye-yc);
              d3 = (xm-xc)*(xm-xc) + (ym-yc)*(ym-yc); 
	      ddd = MIN(d1,d2);
              dist = 0.5*((1+ind[i1][j1])*dist_3 + (1-ind[i1][j1])*dist_2);
	      
	      if (!nl AND d3 < dist) {
		x[ipt] = xm;
		y[ipt] = ym;
		ipt++;
		x[ipt] = xm;
		y[ipt] = ym;
		ipt++;
	      }
	      
	      if (ncell < 4) {
		if (nl AND ddd < dist) {
		  x[ipt] = xs;
		  y[ipt] = ys;
		  ipt++;
		  x[ipt] = xe;
		  y[ipt] = ye;
		  ipt++;
		  x[ipt] = xm;
		  y[ipt] = ym;
		  ipt++;
		  x[ipt] = xm;
		  y[ipt] = ym;
		  ipt++;
		}
	      }
	      else {
		if (nl AND d1 < dist) {
		  x[ipt] = xs;
		  y[ipt] = ys;
		  ipt++;
		  x[ipt] = xm;
		  y[ipt] = ym;
		  ipt++;
		}
		if (nl AND d2 < dist) {
		  x[ipt] = xe;
		  y[ipt] = ye;
		  ipt++;
		  x[ipt] = xm;
		  y[ipt] = ym;
		  ipt++;
		}
	      }
	    }

	if (debug) {
	  fprintf(stderr,"top line: %d, %d, %d\n",ind[0][2],ind[1][2],ind[2][2]);
	  fprintf(stderr,"cen line: %d, %d, %d\n",ind[0][1],ind[1][1],ind[2][1]);
	  fprintf(stderr,"bot line: %d, %d, %d\n",ind[0][0],ind[1][0],ind[2][0]);
        }

	kappa = kappa_arc(x,y,c[i][j],ipt,ptr_c,debug,i,j);
	
        ptr_c->x1 = x[0];
        ptr_c->y1 = y[0];
        ptr_c->x2 = x[1];
        ptr_c->y2 = y[1];
        ptr_c->x3 = x[2];
        ptr_c->y3 = y[2];
      }
    }

  /* periodic BC */
  make_bc_pts(ale,nx,ny);
  
  return;
}

/* ------------------------------------------------------------------- */
int get_root(double a, double b, double c, double x0, double y0,
	     double xx, double *root)
{
  int nr=0;
  double d1,d2,r1,r2;

  d1 = xx*xx + a*xx + c;
  r1 = 0.5*(-b + sqrt(b*b - 4.*d1));
  r2 = 0.5*(-b - sqrt(b*b - 4.*d1));

  if (r1 >= 0.0 AND r1 <= 1.0) {
    nr++;
    *root = r1;
  }

  if (r2 >= 0.0 AND r2 <= 1.0) {
    nr++;
    *root = r2;
  }

  if (nr EQ 2) {
    nr = 1;
    d1 = fabs(y0-r1);
    d2 = fabs(y0-r2);
    if (d1 < d2)
      *root = r1;
    else
      *root = r2;
  }

  return nr;
}

/* ------------------------------------------------------------------- */
int get_intersection(double x0, double y0, double a, double b, double c, 
		     double *x1, double *y1)
{
  int ii;
  double xx,yy;

  if (x0 EQ 0.0 OR x0 EQ 1.0) {
    ii = get_root(a,b,c,x0,y0,x0,&yy);
    if (ii) {
      *x1 = x0;
      *y1 = yy;
    }
    else {
      xx = modf(y0+0.5,&yy);
      ii = get_root(b,a,c,y0,x0,yy,&xx);
      if (ii) {
	*x1 = xx;
	*y1 = yy;
      }
    }
  }
  
  else {
    ii = get_root(b,a,c,y0,x0,y0,&xx);
    if (ii) {
      *x1 = xx;
      *y1 = y0;
    }
    else {
      yy = modf(x0+0.5,&xx);
      ii = get_root(a,b,c,x0,y0,xx,&yy);
      if (ii) {
	*x1 = xx;
	*y1 = yy;
      }
    }
  }
  
  return ii;
}

/* ------------------------------------------------------------------- */
double kappa_arc(double *x, double *y, double cc, int ipt, SEGS *ptr,
         int debug, int ii, int jj)
{
  int i,i_check;
  double a11,a12,a13,a22,a23,a33,b1,b2,b3,tmp;
  double det,top,a,b,c,x0,y0,r2;
  double xs,ys,xe,ye,x1,y1;
  double area_diff,hr,base;
  double k;

  xs = ptr->x1;  
  ys = ptr->y1;
  xe = ptr->x2;  
  ye = ptr->y2;
  
  a11=a12=a13=a22=a23=a33=b1=b2=b3=0.0;
  
  for (i=0; i<ipt; i++) {
    a11 += 1.0; 
    a12 += y[i];
    a13 += x[i];
    a22 += y[i]*y[i];
    a23 += y[i]*x[i];
    a33 += x[i]*x[i];
    tmp = x[i]*x[i] + y[i]*y[i];
    b1 -= tmp;
    b2 -= y[i]*tmp;
    b3 -= x[i]*tmp;
  }
  
  det = a11*(a22*a33-a23*a23) - a12*(a12*a33-a13*a23) +
    a13*(a12*a23-a22*a13);
  /*
  if (debug) {
  fprintf(stderr,"cell: (%d,%d), points: %d\n",ii,jj,ipt);
  fprintf(stderr,"det circle: %e\n",det);
  fprintf(stderr,"det line  : %e\n",a22*a33 - a23*a23);
  }
  */

  /* DEFAULT: straight line */
  x[0] = xs;
  y[0] = ys;
  x[1] = xe;
  y[1] = ye;
  x[2] = 0.5*(xs+xe);
  y[2] = 0.5*(ys+ye);

  if (fabs(det) > 1.e-5) {
    top = b1*(a22*a33-a23*a23) - a12*(b2*a33-b3*a23) +
      a13*(b2*a23-a22*b3);
    c = top/det;
    top = a11*(b2*a33-b3*a23) - b1*(a12*a33-a13*a23) +
      a13*(a12*b3-b2*a13);
    b = top/det;
    top = a11*(a22*b3-b2*a23) - a12*(a12*b3-a13*b2) +
      b1*(a12*a23-a22*a13);
    a = top/det;
    x0 = -a/2.;
    y0 = -b/2.;
    r2 = x0*x0 + y0*y0 - c;
    if(r2 == 0.) 
      {
	nrerror("r2 = 0\n");
      }
    else
      k = 1./sqrt(r2);
      
    if (debug) 
      {
       fprintf(stderr,"det,a,b,c: %e, %e, %e, %e\n",det,a,b,c);
       fprintf(stderr,"x0,y0,r^2: %e, %e, %e\n",x0,y0,r2);
      }
  }
  else 
    {
      k=0.
      if (debug) 
	{
	  fprintf(stderr,"STRAIGHT LINE(?): %e, POINTS: %d\n",det,ipt);
	  fprintf(stderr,"x0,y0: %f, %f\n",x[0],y[0]);
	  fprintf(stderr,"x1,y1: %f, %f\n",x[1],y[1]);
	  fprintf(stderr,"x2,y2: %f, %f\n",x[2],y[2]);
	}
    }
  return k;
}
