#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gp.h>

int echo_ifetch(char *name_variable, int def_val,  char *message);
double echo_dfetch(char *name_variable, double def_val,  char *message);
void bulerror(char error_text[]);

int main(int argc, char *argv[])
{
  int nx,ny,nz,nvar;
  int i,j,k,l,ishift;
  int clip;
  float *flc;
  float cliplength;
  float tmp;
  int t;
  char s[256], datbfile[256];
  FILE *fptr, *newfptr;

  if (argc != 3) {
    fprintf(stderr, "usage: %s cliplength time \n", argv[0]);
    exit(1);
  }
  cliplength = atof(argv[1]); 
  t = atoi(argv[2]);
  
  sprintf(datbfile, "%s.%d", "plot.datb",t);
  fprintf(stdout,"opening file %s \n",datbfile);

  fptr = fopen(datbfile, "rt");
  if(fptr == NULL) bulerror("datbfile unopened\n");
  fread (&nx, sizeof (int), 1, fptr);
  fread (&ny, sizeof (int), 1, fptr);
  fread (&nz, sizeof (int), 1, fptr);
  fread (&nvar, sizeof (int), 1, fptr);
  fprintf(stdout,"nx = %d\n",nx);
  fprintf(stdout,"ny = %d\n",ny);
  fprintf(stdout,"nz = %d\n",nz);

  if(nvar != 3) bulerror("nvar != 3");
  clip = (int) ( cliplength*nx) ;
  fprintf(stdout,"clip = %d\n",clip);
  flc = (float *) malloc(nx*ny*nz*sizeof(float));
  if(flc == NULL) bulerror("cant alloc array");

  sprintf(datbfile, "%s.%d.shift.%g", "plot.datb",t,cliplength);
  fprintf(stdout,"writing to file %s \n",datbfile);
  newfptr = fopen(datbfile, "wb");
  fwrite(&nx, sizeof(int), 1, newfptr);
  fwrite(&ny, sizeof(int), 1, newfptr);
  fwrite(&nz, sizeof(int), 1, newfptr);
  fwrite(&nvar, sizeof(int), 1, newfptr);

  for (i = 0; i < nvar; i++)
    fread (s, sizeof(char), 256, fptr);

  sprintf(s, "u");  fwrite(s, sizeof(char), 256, newfptr);
  sprintf(s, "v");  fwrite(s, sizeof(char), 256, newfptr);
  sprintf(s, "c");  fwrite(s, sizeof(char), 256, newfptr);
  
  for (l = 0; l < nvar; l++) 
    {
    for (i = 0; i < nx; i++)
      for (j = 0; j < ny; j++)
        for (k = 0; k < nz; k++)
	  {
	    fread (&tmp, sizeof (float), 1, fptr);
	    ishift = (i + nx - clip)%nx;
	    if(ishift < 0) bulerror("negative ishift");
	    if(ishift > nx) bulerror("ishift > nx");
	    flc[ishift + (nx)*j + (nx)*(ny)*k]=  tmp;
	  }
    for (i = 0; i < nx; i++)
      for (j = 0; j < ny; j++)
        for (k = 0; k < nz; k++)
	  {
	    tmp = flc[i + (nx)*j + (nx)*(ny)*k];
	    fwrite(&tmp, sizeof(float), 1, newfptr);
	  }            
    }
  fclose(newfptr);
  fclose(fptr);

  exit(1);
}

int echo_ifetch(char *name_variable, int def_val,  char *message)
  {
    int x;
    char line[100];
    char *p;
    line[0] = '\0';
    x = GP_ifetch(name_variable, def_val, message);
    p = strcat(line,name_variable);
    p = strcat(line," = %d \n");
    printf(line,x);
    return x;
  }
    

double echo_dfetch(char *name_variable, double def_val,  char *message)
  {
    double x;
    char line[100];
    char *p;
    line[0] = '\0';
    x = GP_dfetch(name_variable, def_val, message);
    p = strcat(line,name_variable);
    p = strcat(line," = %g \n");
    printf(line,x);
    return x;
  }
    
void bulerror(char error_text[])
     /* error */
{
        fprintf(stderr,"@@@ Bulles error: ");
        fprintf(stderr,"%s\n",error_text);
        fprintf(stderr,"Fatal, exiting to system...\n");
        exit(1);
}
