/* A program to convert datb popiplot files into gnuplot-readable files */

#include <stdio.h>
#include <stdlib.h>
#include <gp.h>
void nrerror(char *);

int main(int argc, char *argv[])
{
  int nx, ny, nz, nvar,snvar;
  char filename[256];
  char fileg[256];
  int i,j,t,l;
  FILE *fptr,*fptr_gnuplot;
  char name[256];
  float x,y,h,tmp;
  if (argc != 3) {
    fprintf(stderr, "usage: %s time variable_number \n", argv[0]);
    exit(1);
  }
  t = atoi(argv[1]); 
  snvar = atoi(argv[2]); 
  sprintf(filename, "%s.%d", "plot.datb",t);
  sprintf(fileg, "%s.%d", "gnuplot",t);

  fprintf(stdout,"opening file %s \n",filename);
  fptr = fopen(filename, "rt");
  fprintf(stdout,"opening file %s \n",fileg);
  fptr_gnuplot = fopen(fileg, "w");
  if(fptr == NULL) nrerror("datbfile unopened\n");
  if(fptr_gnuplot == NULL) nrerror("gnuplot file unopened\n");
  fread (&nx, sizeof (int), 1, fptr);
  fread (&ny, sizeof (int), 1, fptr);
  fread (&nz, sizeof (int), 1, fptr);
  fread (&nvar, sizeof (int), 1, fptr);
  fprintf(stdout,"nx = %d\n",nx);
  fprintf(stdout,"ny = %d\n",ny);
  fprintf(stdout,"nz = %d\n",nz);
  fprintf(stdout,"nvar = %d\n",nvar);
  h = 1./(nx-2);
  for (i = 0; i < nvar; i++)
    {
      fread (name, sizeof(char), 256, fptr);
      fprintf(stdout,"variable %d  = %s\n",i+1,name);
    }

  /* skip first snvar - 1 arrays */

  for (l = 0; l < (snvar-1); l++) 
    for (i = 0; i < nx; i++)
      for (j = 0; j < ny; j++)
	  {
	    fread (&tmp, sizeof (float), 1, fptr);
	  }
  /* read array */

  for (i = 0; i < nx; i++)  
    for (j = 0; j < ny; j++)
      {
	x = (i-1)*h;
	y = (j-1)*h;
	fread (&tmp, sizeof (float), 1, fptr); 
	fprintf(fptr_gnuplot,"%g %g %g\n",x,y,tmp);
      }
  fclose(fptr);
  fclose(fptr_gnuplot);
  exit(1);
}

void nrerror(char error_text[])
     /* error */
{
        fprintf(stderr," run-time error...\n");
        fprintf(stderr,"%s\n",error_text);
        fprintf(stderr,"...now exiting to system...\n");
}

